package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Branch;

import javax.annotation.Nonnull;

/**
 * Describes a branch to {@link ScmExtendedCommandFactory#updateDefaultBranch set as the default}.
 * <p>
 * When updating the default branch, it is <i>strongly</i> encouraged to use the branch's {@link Branch#getId ID}
 * rather than its {@link Branch#getDisplayId() display ID}. Using the display ID may result in the update failing,
 * or in the "wrong" branch being made the default.
 *
 * @since 4.6
 */
public class UpdateDefaultBranchCommandParameters extends AbstractCommandParameters {

    private final String branchId;

    private UpdateDefaultBranchCommandParameters(Builder builder) {
        branchId = builder.branchId;
    }

    /**
     * @return retrieves the {@link Branch#getId ID} of the branch that should be set as the default
     */
    @Nonnull
    public String getBranchId() {
        return branchId;
    }

    public static class Builder {

        private final String branchId;

        public Builder(@Nonnull String branchId) {
            this.branchId = requireNonBlank(branchId, "branchId");
        }

        @Nonnull
        public UpdateDefaultBranchCommandParameters build() {
            return new UpdateDefaultBranchCommandParameters(this);
        }
    }
}
