package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Thrown to indicate that the requested SCM's implementation is not up-to-date with the current SPI.
 *
 * @since 6.7
 */
public class IncompleteScmException extends ScmException {

    public IncompleteScmException(@Nonnull KeyedMessage message, @Nonnull String scmId) {
        super(message, scmId);
    }
}
