package com.atlassian.bitbucket.scm;

import javax.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;

/**
 * Describes an output handler which processes the standard error or standard output stream from a {@link Command}.
 *
 * @see CommandAware
 * @since 8.0
 */
public interface CommandOutputHandlerSupport extends CommandHandlerSupport {

    /**
     * Process an output stream generated by the external process (either stdout or stderr)
     *
     * @param output the external process' output stream (available as an input to this class)
     * @throws IOException if there is a problem processing the output
     */
    void process(@Nonnull InputStream output) throws IOException;
}
