package com.atlassian.bitbucket.scm;

import javax.annotation.Nonnull;
import java.io.IOException;

/**
 * Provides the common callback methods for input, output and error handlers which process the standard input, error
 * or output stream from a {@link Command}.
 *
 * @see CommandAware
 * @since 8.0
 */
public interface CommandHandlerSupport {

    /**
     * Called when the process completes. This call allows the output handler to close any
     * open resources and finalize any processing.
     *
     * @throws IOException if there is a problem completing processing
     */
    default void complete() throws IOException {
    }

    /**
     * Set the watchdog that this handler should be resetting to prevent the process from being terminated.
     * The watchdog should be called periodically based on output generated by the process.
     *
     * @param watchdog process watchdog instance.
     */
    void setWatchdog(@Nonnull Watchdog watchdog);
}
