package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

/**
 * @since 5.10
 */
public class SimpleRefChangeDetails implements RefChangeDetails {

    private final List<Commit> commits;
    private final int totalCommits;

    public SimpleRefChangeDetails(Builder builder) {
        commits = builder.commits.build();
        totalCommits = builder.totalCommits;
    }

    @Nonnull
    @Override
    public List<Commit> getCommits() {
        return commits;
    }

    @Override
    public int getTotal() {
        return totalCommits;
    }

    public static class Builder extends BuilderSupport {

        private ImmutableList.Builder<Commit> commits = new ImmutableList.Builder<>();
        private int totalCommits;

        @Nonnull
        public RefChangeDetails build() {
            return new SimpleRefChangeDetails(this);
        }

        @Nonnull
        public Builder commits(@Nonnull Iterable<Commit> value) {
            addIf(Objects::nonNull, commits, value);
            return this;
        }

        @Nonnull
        public Builder totalCommits(int value) {
            totalCommits = value;
            return this;
        }
    }
}