package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.validation.ArgumentValidationException;

/**
 * Thrown when attempting to modify the {@link PullRequestRole#AUTHOR author} of a pull request. A pull request's
 * author cannot be assigned to any other role, nor can they be removed. For example, attempting to reassign the
 * author of a pull request as a {@link PullRequestRole#REVIEWER reviewer} may trigger this exception.
 *
 * @see PullRequestService#addReviewer(int repositoryId, long pullRequestId, String username) Adding a reviewer
 * @see PullRequestService#removeReviewer(int repositoryId, long pullRequestId, String username) Removing a reviewer
 */
public class UnmodifiablePullRequestRoleException extends ArgumentValidationException {

    public UnmodifiablePullRequestRoleException(KeyedMessage message) {
        super(message);
    }
}
