package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.activity.Activity;

import javax.annotation.Nonnull;

/**
 * A pull request activity, used to track significant events in a pull request's lifecycle.
 * <p>
 * Some activities, such as {@link PullRequestMergeActivity when a pull request is merged}, include additional data and
 * have their own type. Other activities, like {@link PullRequestAction#OPENED when a pull request is opened} provide no
 * additional information beyond this interface. The {@link PullRequestActivityVisitor} can be used to work with the
 * various types safely.
 */
public interface PullRequestActivity extends Activity {

    void accept(@Nonnull PullRequestActivityVisitor visitor);

    @Nonnull
    PullRequestAction getAction();

    @Nonnull
    PullRequest getPullRequest();
}
