package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Exception thrown when a migration job is submitted to be run but the maximum number of concurrent migration jobs
 * are already running on that node.
 * <p>
 * The maximum number of concurrent migration jobs is defined by the {@code migration.threadpool.size} application
 * property.
 * 
 * @see MigrationService#startExport(ExportRequest)
 * @see MigrationService#startImport(ImportRequest)
 * @since 5.14
 */
public class MaxConcurrentMigrationJobsException extends MigrationException {

    public MaxConcurrentMigrationJobsException(@Nonnull KeyedMessage message) {
        super(message, null, null);
    }

    public MaxConcurrentMigrationJobsException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, null, cause);
    }
}
