package com.atlassian.bitbucket.job;

import javax.annotation.Nonnull;

/**
 * The severity of {@link JobMessage messages} generated for {@link Job jobs}
 *
 * @since 5.13
 */
public enum JobMessageSeverity {

    INFO(0),
    WARN(1),
    ERROR(2);

    private int id;

    JobMessageSeverity(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    /**
     * @param id the {@link #getId() unique identifier} for the type (<i>not</i> its {@link #ordinal()})
     * @return the matching type
     * @throws IllegalArgumentException if the specified ID does not match a type
     */
    @Nonnull
    public static JobMessageSeverity fromId(int id) {
        for (JobMessageSeverity value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No JobMessageSeverity is associated with ID [" + id + "]");
    }
}
