package com.atlassian.bitbucket.event.project;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.project.Project;

import javax.annotation.Nonnull;

/**
 * Event raised to indicate that a project has been successfully imported to this instance.
 * <p>
 * This event is internally audited at the {@link CoverageLevel#BASE} level
 *
 * @since 5.13
 */
public class ProjectImportedEvent extends ProjectCreatedEvent {

    public ProjectImportedEvent(@Nonnull Object source, @Nonnull Project project) {
        super(source, project);
    }
}
