package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;

import javax.annotation.Nonnull;

/**
 * This event is raised before a user or group's permission is modified. This event is synchronous,
 * allowing listeners to perform operations in the same database transaction where the permission is modified.
 * <p>
 * This event is {@link CancelableEvent cancelable}. A listener may prevent the permission
 * from being modified by {@link #cancel(KeyedMessage) canceling} this event.
 * Throwing an exception <i>will not</i> prevent the permission from being modified;
 * the exception will be logged and ignored.
 */
public interface PermissionModificationRequestedEvent extends CancelableEvent {

    /**
     * @return the new permission replacing the previous value
     */
    @Nonnull
    Permission getNewValue();

    /**
     * @return the old permission being replaced
     */
    @Nonnull
    Permission getOldValue();
}
