package com.atlassian.bitbucket.event.migration;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when database migration begins.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
public class MigrationStartedEvent extends MigrationEvent {

    public MigrationStartedEvent(@Nonnull Object source) {
        super(source);
    }
}
