package com.atlassian.bitbucket.event.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;

import javax.annotation.Nonnull;

/**
 * Raised when a {@link MeshNode} comes online or goes offline.
 * <p>
 * <b>Note</b>: It is not always detected when a node goes offline, and, since the node was never observed going
 * offline, when it comes back online no event is raised since its availability was not observed to change. This
 * is an <i>informational</i> event only and is not guaranteed.
 *
 * @since 8.0
 */
public class MeshNodeAvailabilityChangedEvent extends AbstractMeshNodeEvent {

    private final boolean available;

    public MeshNodeAvailabilityChangedEvent(@Nonnull Object source, @Nonnull MeshNode node, boolean available) {
        super(source, node);
        this.available = available;
    }

    /**
     * @return {@code true} if the node has come online after being offline; otherwise, {@code false} if the node
     *         has gone offline after being online
     */
    public boolean isAvailable() {
        return available;
    }
}
