package com.atlassian.bitbucket.event.backup;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when a backup fails.
 * <p>
 * This event is internally audited with {@link com.atlassian.audit.entity.CoverageLevel#BASE} level
 */
@AsynchronousPreferred
@EventName("stash.backup.failed")
public class BackupFailedEvent extends BackupEndedEvent {

    public BackupFailedEvent(@Nonnull Object source) {
        super(source);
    }
}
