package com.atlassian.bitbucket.comment;

/**
 * Enumerates the possible {@link Comment#getState() states} a comment can be in.
 *
 * @see Comment#getState()
 * @since 6.7
 */
public enum CommentState {

    /**
     * The {@link Comment comment} is open.
     */
    OPEN(100),
    /**
     * The {@link Comment pending comment} only visible to the author.
     *
     * @since 7.7
     */
    PENDING(20),
    /**
     * The {@link Comment comment} has been resolved.
     */
    RESOLVED(200);

    private final int id;

    CommentState(int id) {
        this.id = id;
    }

    public static CommentState fromId(int id) {
        for (CommentState value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No CommentState is associated with ID [" + id + "]");
    }

    public int getId() {
        return id;
    }
}