/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server;

import com.atlassian.bitbucket.server.Feature;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleFeature
implements Feature {
    private final boolean dataCenter;
    private final String key;

    private SimpleFeature(Builder builder) {
        this.dataCenter = builder.dataCenter;
        this.key = builder.key;
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isDataCenter() {
        return this.dataCenter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFeature that = (SimpleFeature)o;
        return this.dataCenter == that.dataCenter && this.key.equals(that.key);
    }

    public int hashCode() {
        return Objects.hash(this.dataCenter, this.key);
    }

    public static class Builder {
        private final String key;
        private boolean dataCenter;

        public Builder(@Nonnull String key) {
            this.key = Objects.requireNonNull(key, "key");
        }

        @Nonnull
        public SimpleFeature build() {
            return new SimpleFeature(this);
        }

        @Nonnull
        public Builder dataCenter(boolean value) {
            this.dataCenter = value;
            return this;
        }
    }
}

