/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class BuilderSupport {
    protected static final Predicate<String> NOT_BLANK = StringUtils::isNotBlank;

    protected static <T> boolean addIf(@Nonnull Predicate<? super T> predicate, @Nonnull Collection<T> collection, @Nullable T value) {
        return predicate.test(value) && collection.add(value);
    }

    protected static <T> boolean addIf(@Nonnull Predicate<? super T> predicate, @Nonnull ImmutableCollection.Builder<T> builder, @Nullable T value) {
        if (predicate.test(value)) {
            builder.add(value);
            return true;
        }
        return false;
    }

    @SafeVarargs
    protected static <T> void addIf(@Nonnull Predicate<? super T> predicate, @Nonnull Collection<T> collection, @Nullable T value, T ... values) {
        if (BuilderSupport.addIf(predicate, collection, value) && values != null && values.length > 0) {
            BuilderSupport.addIf(predicate, collection, Arrays.asList(values));
        }
    }

    @SafeVarargs
    protected static <T> void addIf(@Nonnull Predicate<? super T> predicate, @Nonnull ImmutableCollection.Builder<T> builder, @Nullable T value, T ... values) {
        if (BuilderSupport.addIf(predicate, builder, value) && values != null && values.length > 0) {
            BuilderSupport.addIf(predicate, builder, Arrays.asList(values));
        }
    }

    protected static <T> void addIf(@Nonnull Predicate<? super T> predicate, @Nonnull Collection<T> collection, @Nullable Iterable<? extends T> values) {
        if (values != null) {
            Iterables.addAll(collection, (Iterable)Iterables.filter(values, predicate::test));
        }
    }

    protected static <T> void addIf(@Nonnull Predicate<? super T> predicate, @Nonnull ImmutableCollection.Builder<T> builder, @Nullable Iterable<? extends T> values) {
        if (values != null) {
            builder.addAll(Iterables.filter(values, predicate::test));
        }
    }

    @Nonnull
    protected static String checkNotBlank(@Nullable String value, @Nullable String name) {
        return BuilderSupport.requireNonBlank(value, name);
    }

    @Nonnull
    protected static String requireNonBlank(@Nullable String value, @Nullable String name) {
        Objects.requireNonNull(value, name);
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException("A non-blank " + StringUtils.defaultString((String)name, (String)"value") + " is required");
        }
        return value;
    }
}

