/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DiffContext {
    private final int contextLines;
    private final String fromHash;
    private final int maxLineLength;
    private final int maxLines;
    private final String toHash;
    private final DiffWhitespace whitespace;

    private DiffContext(Builder builder) {
        this.contextLines = builder.contextLines;
        this.fromHash = builder.fromHash;
        this.maxLineLength = builder.maxLineLength;
        this.maxLines = builder.maxLines;
        this.toHash = builder.toHash;
        this.whitespace = builder.whitespace;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    @Nullable
    public String getFromHash() {
        return this.fromHash;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public static class Builder
    extends BuilderSupport {
        private final String fromHash;
        private final String toHash;
        private int contextLines;
        private int maxLineLength;
        private int maxLines;
        private DiffWhitespace whitespace;

        public Builder(@Nullable String fromHash, @Nonnull String toHash) {
            this.fromHash = StringUtils.trimToNull((String)fromHash);
            this.toHash = Builder.checkNotBlank(toHash, "toHash");
            this.whitespace = DiffWhitespace.SHOW;
        }

        @Nonnull
        public DiffContext build() {
            return new DiffContext(this);
        }

        @Nonnull
        public Builder contextLines(int value) {
            this.contextLines = value;
            return this;
        }

        @Nonnull
        public Builder maxLineLength(int value) {
            this.maxLineLength = value;
            return this;
        }

        @Nonnull
        public Builder maxLines(int value) {
            this.maxLines = value;
            return this;
        }

        @Nonnull
        public Builder whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = Objects.requireNonNull(value, "whitespace");
            return this;
        }
    }
}

