/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.hook.repository.RepositoryHookVeto;
import com.atlassian.bitbucket.hook.repository.SimpleRepositoryHookVeto;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryHookResult {
    private static final RepositoryHookResult ACCEPTED = new RepositoryHookResult();
    private final List<RepositoryHookVeto> vetoes;

    private RepositoryHookResult() {
        this.vetoes = Collections.emptyList();
    }

    private RepositoryHookResult(@Nonnull Builder builder) {
        this.vetoes = builder.vetoes.build();
    }

    @Nonnull
    public static RepositoryHookResult accepted() {
        return ACCEPTED;
    }

    @Nonnull
    public static RepositoryHookResult rejected(@Nonnull String summaryMessage, @Nonnull String detailMessage) {
        return new Builder().veto(summaryMessage, detailMessage).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryHookResult result = (RepositoryHookResult)o;
        return Objects.equals(this.vetoes, result.vetoes);
    }

    @Nonnull
    public List<RepositoryHookVeto> getVetoes() {
        return this.vetoes;
    }

    public int hashCode() {
        return Objects.hash(this.vetoes);
    }

    public boolean isAccepted() {
        return this.vetoes.isEmpty();
    }

    public boolean isRejected() {
        return !this.isAccepted();
    }

    public static class Builder {
        private final ImmutableList.Builder<RepositoryHookVeto> vetoes = ImmutableList.builder();
        private boolean rejected;

        public Builder() {
        }

        public Builder(@Nonnull RepositoryHookResult result) {
            this.vetoes.addAll(Objects.requireNonNull(result, "result").getVetoes());
            this.rejected = result.isRejected();
        }

        @Nonnull
        public Builder add(@Nullable RepositoryHookResult value) {
            if (value != null) {
                this.vetoes.addAll(value.getVetoes());
                this.rejected |= value.isRejected();
            }
            return this;
        }

        @Nonnull
        public RepositoryHookResult build() {
            return this.rejected ? new RepositoryHookResult(this) : ACCEPTED;
        }

        public boolean isRejected() {
            return this.rejected;
        }

        @Nonnull
        public Builder veto(@Nonnull String summaryMessage, @Nonnull String detailedMessage) {
            this.vetoes.add((Object)new SimpleRepositoryHookVeto(summaryMessage, detailedMessage));
            this.rejected = true;
            return this;
        }
    }
}

