/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.job;

import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class JobSearchRequest {
    private final Set<JobState> states;
    private final String type;

    private JobSearchRequest(Builder builder) {
        this.states = builder.states.build();
        this.type = builder.type;
    }

    @Nonnull
    public Set<JobState> getStates() {
        return this.states;
    }

    @Nonnull
    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobSearchRequest that = (JobSearchRequest)o;
        return Objects.equals(this.getType(), that.getType());
    }

    public int hashCode() {
        return Objects.hashCode(this.getType());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<JobState> states = ImmutableSet.builder();
        private String type;

        @Nonnull
        public JobSearchRequest build() {
            return new JobSearchRequest(this);
        }

        @Nonnull
        public Builder state(@Nonnull JobState value) {
            Builder.addIf(Objects::nonNull, this.states, value);
            return this;
        }

        @Nonnull
        public Builder states(@Nonnull JobState value, JobState ... moreValues) {
            Builder.addIf(Objects::nonNull, this.states, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder states(@Nonnull Iterable<JobState> values) {
            Builder.addIf(Objects::nonNull, this.states, values);
            return this;
        }

        @Nonnull
        public Builder type(@Nullable String value) {
            this.type = StringUtils.trimToNull((String)value);
            return this;
        }
    }
}

