/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.build;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class BuildStatusSetRequest {
    private final String commitId;
    private final long dateAdded;
    private final String description;
    private final String key;
    private final String name;
    private final BuildState state;
    private final String url;

    private BuildStatusSetRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.dateAdded = builder.dateAdded > 0L ? builder.dateAdded : System.currentTimeMillis();
        this.description = builder.description;
        this.key = builder.key;
        this.name = builder.name;
        this.state = builder.state;
        this.url = builder.url;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Date getDateAdded() {
        return new Date(this.dateAdded);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public BuildState getState() {
        return this.state;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private long dateAdded;
        private String description;
        private String key;
        private String name;
        private BuildState state;
        private String url;

        public Builder(@Nonnull String commitId) {
            this.commitId = Builder.checkNotBlank(commitId, "commitId");
        }

        @Nonnull
        public BuildStatusSetRequest build() {
            Builder.checkNotBlank(this.key, "key");
            Objects.requireNonNull(this.state, "state");
            Builder.checkNotBlank(this.url, "url");
            return new BuildStatusSetRequest(this);
        }

        @Nonnull
        public Builder dateAdded(long value) {
            this.dateAdded = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public Builder dateAdded(@Nullable Date value) {
            this.dateAdded = value == null ? 0L : value.getTime();
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = StringUtils.trimToNull((String)StringUtils.abbreviate((String)value, (int)255));
            return this;
        }

        @Nonnull
        public Builder key(@Nonnull String value) {
            this.key = Builder.checkNotBlank(value, "key");
            return this;
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull BuildState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String value) {
            this.url = Builder.checkNotBlank(value, "url");
            return this;
        }
    }
}

