/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class EditFileRequest {
    private final ApplicationUser author;
    private final String branch;
    private final InputSupplier<InputStream> content;
    private final String message;
    private final String path;
    private final Repository repository;
    private final String sourceBranch;
    private final String sourceCommitId;

    private EditFileRequest(Builder builder) {
        this.author = builder.author;
        this.branch = builder.branch;
        this.content = builder.content;
        this.message = builder.message;
        this.path = builder.path;
        this.repository = builder.repository;
        this.sourceCommitId = builder.sourceCommitId;
        this.sourceBranch = StringUtils.defaultString((String)builder.sourceBranch, (String)builder.branch);
    }

    @Nonnull
    public Optional<ApplicationUser> getAuthor() {
        return Optional.ofNullable(this.author);
    }

    @Nonnull
    public String getBranch() {
        return this.branch;
    }

    @Nonnull
    public InputSupplier<InputStream> getContent() {
        return this.content;
    }

    @Nonnull
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getSourceBranch() {
        return this.sourceBranch;
    }

    @Nonnull
    public Optional<String> getSourceCommitId() {
        return Optional.ofNullable(this.sourceCommitId);
    }

    public static class Builder
    extends BuilderSupport {
        private final String branch;
        private final String path;
        private final Repository repository;
        private ApplicationUser author;
        private InputSupplier<InputStream> content;
        private String message;
        private String sourceBranch;
        private String sourceCommitId;

        public Builder(@Nonnull String branch, @Nonnull String path, @Nonnull Repository repository) {
            this.branch = Objects.requireNonNull(branch, "branch");
            this.path = Builder.requireNonBlank(path, "path");
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        @Nonnull
        public Builder author(@Nullable ApplicationUser value) {
            this.author = value;
            return this;
        }

        @Nonnull
        public EditFileRequest build() {
            Objects.requireNonNull(this.content, "content");
            return new EditFileRequest(this);
        }

        @Nonnull
        public Builder content(@Nonnull InputSupplier<InputStream> value) {
            this.content = Objects.requireNonNull(value, "content");
            return this;
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = value;
            return this;
        }

        @Nonnull
        public Builder sourceBranch(@Nullable String value) {
            this.sourceBranch = value;
            return this;
        }

        @Nonnull
        public Builder sourceCommitId(@Nullable String value) {
            this.sourceCommitId = value;
            return this;
        }
    }
}

