package com.atlassian.bitbucket.user;

import javax.annotation.Nonnull;

/**
 * A minimal person abstraction, suitable for describing authors, committers and other people who may not have
 * an explicit {@link ApplicationUser user} account.
 */
public interface Person {

    /**
     * Retrieves the person's e-mail address.
     *
     * @return the e-mail address
     */
    String getEmailAddress();

    /**
     * Retrieves the person's name.
     *
     * @return the name
     */
    @Nonnull
    String getName();
}
