package com.atlassian.bitbucket.user;

import javax.annotation.Nonnull;

/**
 * Extends a group, which is a simple {@code String} name generally, with additional details relating to the directory
 * backing the group.
 */
public interface DetailedGroup {

    /**
     * Retrieves the group's name.
     *
     * @return the group name
     */
    @Nonnull
    String getName();

    /**
     * Retrieves a flag indicating whether the directory in which this group is stored supports deleting groups.
     * <p>
     * Note: Because a group is really nothing more than a name, it is possible a given group exists in multiple
     * directories. As a result, it's possible that "deleting" a group will not remove it from the system entirely;
     * it may still exist in other directories. Additionally, because a given group can exist in multiple directories,
     * it is possible that it is deletable in some and not in others. <i>If a group is deletable in any directory, it
     * is considered deletable.</i>
     *
     * @return {@code true} if at least one directory supports deleting the group; otherwise, {@code false} if none do
     */
    boolean isDeletable();
}
