package com.atlassian.bitbucket.scm.ref;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

public class AbstractRefCommandParameters extends AbstractCommandParameters {

    private final ApplicationUser author;
    private final String message;
    private final String name;

    protected AbstractRefCommandParameters(AbstractRefBuilder builder) {
        author = builder.author;
        message = builder.message;
        name = builder.name;
    }

    @Nullable
    public ApplicationUser getAuthor() {
        return author;
    }

    @Nullable
    public String getMessage() {
        return message;
    }

    @Nonnull
    public String getName() {
        return name;
    }

    public abstract static class AbstractRefBuilder<B extends AbstractRefBuilder<B>> {

        private ApplicationUser author;
        private String message;
        private String name;

        @Nonnull
        public B author(@Nonnull ApplicationUser value) {
            author = requireNonNull(value, "author");

            return self();
        }

        @Nonnull
        public B message(@Nullable String value) {
            message = value;

            return self();
        }

        @Nonnull
        public B name(@Nonnull String value) {
            name = requireNonNull(value, "name");

            return self();
        }

        @Nonnull
        protected abstract B self();

        protected void validate() {
            if (StringUtils.isBlank(name)) {
                throw new IllegalStateException("When working with refs a name is required.");
            }
        }
    }
}