package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.RepositoryBranchesRequest;

import javax.annotation.Nonnull;

public class BranchesCommandParameters extends AbstractRefsCommandParameters {

    private BranchesCommandParameters(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder> {

        public Builder() {
        }

        public Builder(@Nonnull RepositoryBranchesRequest request) {
            super(request);
        }

        @Nonnull
        public BranchesCommandParameters build() {
            return new BranchesCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
