package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Occurs when a repository is offline, i.e., when the node on which a repository is present becomes unreachable.
 *
 * @since 7.12
 */
public class RepositoryOfflineException extends IllegalRepositoryStateException {

    private final KeyedMessage detailedMessage;

    /**
     * @param message must not be {@code null}
     * @deprecated in 7.15 for removal in 8.0. Use {@link #RepositoryOfflineException(KeyedMessage, KeyedMessage)}
     *         instead and provide a detailed message.
     */
    @Deprecated
    public RepositoryOfflineException(KeyedMessage message) {
        super(message);
        detailedMessage = null;
    }

    /**
     * @param message         a short summary message, must not be {@code null}
     * @param detailedMessage the more detailed message, must not be {@code null}
     * @since 7.15
     */
    public RepositoryOfflineException(KeyedMessage message, @Nonnull KeyedMessage detailedMessage) {
        super(message);
        this.detailedMessage = requireNonNull(detailedMessage, "detailedMessage");
    }

    /**
     * Returns the detailed message for this exception. This will be {@link Nonnull} once {@link #RepositoryOfflineException(KeyedMessage)}
     * is removed in 8.0.
     *
     * @return the {@link KeyedMessage detailed message}
     * @since 7.15
     */
    @Nullable
    public KeyedMessage getDetailedMessage() {
        return detailedMessage;
    }
}
