package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

public class RefSummary extends AbstractSummary {

    private RefSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, RefSummary> {

        /**
         * Creates and initializes a new builder using details from the provided {@link AbstractSummary summary}.
         *
         * @param summary the summary to initialize this builder from
         */
        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the operation result for the summary
         */
        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public RefSummary build() {
            return new RefSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
