package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import java.util.Set;

/**
 * A {@link PullRequestActivity} added when the reviewers of a pull request are updated.
 *
 * @since 4.4
 */
public interface PullRequestReviewersUpdatedActivity extends PullRequestActivity {

    @Nonnull
    Set<ApplicationUser> getAddedReviewers();

    @Nonnull
    Set<ApplicationUser> getRemovedReviewers();
}
