package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * @since 4.9
 */
public class GetPullRequestMergeConfigRequest extends AbstractPullRequestMergeConfigRequest {

    private GetPullRequestMergeConfigRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, GetPullRequestMergeConfigRequest> {

        public Builder(@Nonnull Project project, @Nonnull String scmId) {
            super(project, scmId);
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        public Builder(@Nonnull String scmId) {
            super(scmId);
        }

        @Nonnull
        @Override
        public GetPullRequestMergeConfigRequest build() {
            return new GetPullRequestMergeConfigRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
