package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Indicates a pull request could not be created because there is already
 * an open pull request with the same to/from repositories and branches.
 */
public class DuplicatePullRequestException extends IntegrityException {

    private static final long serialVersionUID = 1;

    private final PullRequest pullRequest;

    public DuplicatePullRequestException(@Nonnull PullRequest pullRequest, @Nonnull KeyedMessage message) {
        super(message);
        this.pullRequest = requireNonNull(pullRequest, "pullRequest");
    }

    @Nonnull
    public PullRequest getExistingPullRequest() {
        return pullRequest;
    }
}
