package com.atlassian.bitbucket.project;

import javax.annotation.Nonnull;

/**
 * A base implementation of {@link ProjectVisitor} intended for use in building visitors which do not need to return
 * any values. Each {@code visit} method delegates to a {@code doVisit} method. While this class is {@code abstract},
 * {@code visit} methods for all types are implemented to delegate to a {@code doVisit} method and return {@code null},
 * and all {@code doVisit} methods are implemented as no-ops.
 */
@SuppressWarnings("unused") //This is a utility class
public abstract class AbstractVoidProjectVisitor implements ProjectVisitor<Void> {

    /**
     * Invokes {@link #doVisit(Project)} and returns {@code null}.
     *
     * @param project the project to visit
     * @return {@code null}
     */
    @Override
    public Void visit(@Nonnull Project project) {
        doVisit(project);

        return null;
    }

    /**
     * Invokes {@link #doVisit(PersonalProject)} and returns {@code null}.
     *
     * @param project the personal project to visit
     * @return {@code null}
     */
    @Override
    public Void visit(@Nonnull PersonalProject project) {
        doVisit(project);

        return null;
    }

    /**
     * Called by {@link #visit(Project)}. This base implementation does nothing.
     *
     * @param project ignored
     */
    protected void doVisit(@Nonnull Project project) {

    }

    /**
     * Called by {@link #visit(PersonalProject)}. This base implementation does nothing.
     *
     * @param project ignored
     */
    protected void doVisit(@Nonnull PersonalProject project) {

    }
}
