package com.atlassian.bitbucket.label;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.12
 */
public class AlreadyLabeledException extends IllegalEntityStateException {

    private final Label label;
    private final Labelable labelable;

    public AlreadyLabeledException(@Nonnull KeyedMessage message, @Nonnull Label label, @Nonnull Labelable labelable) {
        super(message);
        this.label = requireNonNull(label, "label");
        this.labelable = requireNonNull(labelable, "labelable");
    }

    @Nonnull
    public Label getLabel() {
        return label;
    }

    @Nonnull
    public Labelable getLabelable() {
        return labelable;
    }
}
