package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.scope.Scope;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Base class for changing the configuration for a {@link HookScript}.
 *
 * @since 6.2
 */
public abstract class HookScriptConfigurationEvent extends HookScriptEvent {

    private final Scope scope;

    protected HookScriptConfigurationEvent(@Nonnull Object source, @Nonnull HookScript hookScript,
                                           @Nonnull Scope scope) {
        super(source, hookScript);
        this.scope = requireNonNull(scope, "scope");
    }

    @Nonnull
    public Scope getScope() {
        return scope;
    }
}
