package com.atlassian.bitbucket.event.task;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.task.Task;
import com.atlassian.bitbucket.task.TaskState;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when a task is updated.
 */
@AsynchronousPreferred
@EventName("stash.task.updated")
public class TaskUpdatedEvent extends TaskEvent {

    private final TaskState previousState;
    private final String previousText;

    public TaskUpdatedEvent(@Nonnull Object source, @Nonnull Task task,
                            @Nonnull TaskState previousState, @Nonnull String previousText) {
        super(source, task);

        this.previousState = requireNonNull(previousState, "previousState");
        this.previousText = requireNonNull(previousText, "previousText");
    }

    @Nonnull
    public TaskState getPreviousState() {
        return previousState;
    }

    @Nonnull
    public String getPreviousText() {
        return previousText;
    }

}
