package com.atlassian.bitbucket.event.server;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * An event that is raised when the system is started after being restored from a Zero Downtime Backup.
 * <p>
 * This event is useful to plugins that persist state, indexes or other information to the filesystem.
 * In reaction to this event, plugins should check integrity, repair or recreate their
 * data persisted to the filesystem as necessary.
 * <p>
 * This event can be ignored by plugins that only make use of the database for persistence or
 * is capable of automatically self-healing their persisted data during normal operation.
 *
 * @since 4.8
 */
@AsynchronousPreferred
@EventName("stash.disaster.recovery.triggered")
public class DisasterRecoveryTriggeredEvent extends ApplicationEvent {

    public DisasterRecoveryTriggeredEvent(@Nonnull Object source) {
        super(source);
    }
}