package com.atlassian.bitbucket.event.repository;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import java.util.Collection;

/**
 * Event that is raised when a user pushes one or more {@link Ref refs} to a repository.
 * A push does <i>not</i> guarantee that new commits have been added to the repository; it only guarantees at least one
 * {@link Ref ref} has been {@link RefChange changed}.
 * <p>
 * Listeners that are interested in all ref changes, not just those stemming from pushes (such as pull request merges),
 * should listen for {@link RepositoryRefsChangedEvent}s instead.
 * <p>
 * This event is internally audited with {@link CoverageLevel#FULL} level
 */
@AsynchronousPreferred
public class RepositoryPushEvent extends AbstractRepositoryRefsChangedEvent {

    public RepositoryPushEvent(@Nonnull Object source, @Nonnull Repository repository,
                               @Nonnull Collection<RefChange> refChanges) {
        super(source, repository, refChanges);
    }
}
