package com.atlassian.bitbucket.event.repository;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when a repository is accessed for write but <i>not</i> {@link RepositoryPushEvent pushing refs}.
 * <p>
 * Some SCMs may have multi-step processing for push operations, such as the ref negotiation phase of a
 * {@code git push}. This event should be raised for preliminary requests leading up to the
 * {@link RepositoryPushEvent push}. Some SCM implementations may not raise this event.
 * <p>
 * This event is internally audited with {@link CoverageLevel#FULL} level
 */
@AsynchronousPreferred
public class RepositoryOtherWriteEvent extends RepositoryEvent {

    public RepositoryOtherWriteEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
    }
}
