package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when a comment is deleted on a pull request.
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.comment.deleted")
public class PullRequestCommentDeletedEvent extends PullRequestCommentEvent {

    public PullRequestCommentDeletedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                          @Nonnull Comment comment, @Nullable Comment parent) {
        super(source, pullRequest, comment, parent, CommentAction.DELETED);
    }
}
