package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when an activity is created for a pull request.
 * <p>
 * This event is used for {@link PullRequestActivity} itself and also serves as a base class for other activity event
 * types, see subclasses.
 */
@AsynchronousPreferred
public class PullRequestActivityEvent extends PullRequestEvent {

    private final PullRequestActivity activity;

    public PullRequestActivityEvent(@Nonnull Object source, @Nonnull PullRequestActivity activity) {
        super(source, activity.getPullRequest(), activity.getAction());
        this.activity = requireNonNull(activity, "activity");
    }

    @Nonnull
    public PullRequestActivity getActivity() {
        return activity;
    }
}
