package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;

/**
 * This event is raised before a user or group's permission is revoked. This event is synchronous,
 * allowing listeners to perform operations in the same database transaction where the permission is revoked.
 * <p>
 * This event is {@link CancelableEvent cancelable}. A listener may prevent the permission
 * from being revoked by {@link #cancel(KeyedMessage) canceling} this event.
 * Throwing an exception <i>will not</i> prevent the permission from being revoked;
 * the exception will be logged and ignored.
 */
public interface PermissionRevocationRequestedEvent extends CancelableEvent {

    Permission getPermission();

}
