package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Strings;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * Event signalling global permission changes.
 */
public abstract class GlobalPermissionEvent extends PermissionEvent {

    protected GlobalPermissionEvent(Object source, Permission permission,
                                 String affectedGroup, ApplicationUser affectedUser) {
        super(source, permission, affectedGroup, affectedUser);

        checkArgument(Strings.isNullOrEmpty(affectedGroup) ^ affectedUser == null,
                "Either a user or group can be affected, not both or neither. user=%s, group=%s", affectedUser, affectedGroup);
        checkArgument(permission.isGlobal(), "Require a global permission");
    }
}
