package com.atlassian.bitbucket.event.mirror;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * This event signals that a {@link Repository} has failed to synchronize on a mirror.
 *
 * @since 5.0
 */
public class RepositoryMirrorSynchronizationFailedEvent extends AbstractRepositoryMirrorEvent {

    private RepositoryMirrorSynchronizationFailedEvent(Builder builder) {
        super(builder);
    }

    /**
     * @param source the object which raised this event
     * @param mirrorServerId the id of the mirror for which this event is raised
     * @param repository the repository for which this event should be raised
     * @deprecated in 6.5 for removal in 8.0. Use {@link Builder} instead.
     */
    @Deprecated
    public RepositoryMirrorSynchronizationFailedEvent(@Nonnull Object source, @Nonnull String mirrorServerId,
                                                      @Nonnull Repository repository) {
        super(source, mirrorServerId, repository);
    }

    public static class Builder extends AbstractRepositoryMirrorEvent.Builder<Builder, RepositoryMirrorSynchronizationFailedEvent> {

        @Nonnull
        @Override
        public RepositoryMirrorSynchronizationFailedEvent build() {
            super.validate();
            return new RepositoryMirrorSynchronizationFailedEvent(this);
        }
    }
}