package com.atlassian.bitbucket.event.maintenance;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Fired when maintenance has begun.
 * <p>
 * On receiving this event plugins must avoid running any operations that may use database connections or alter
 * the product's {@link StorageService#getHomeDir() home} or {@link StorageService#getSharedHomeDir() shared home}
 * until maintenance has {@link MaintenanceEndedEvent ended}.
 * <p>
 * Operations running when the event is fired should be terminated at the earliest opportunity. Scheduled operations
 * (that are not scheduled through Atlassian APIs) should be disabled until maintenance is complete.
 * <p>
 * Failure to observe this may result in used database connections becoming invalidated, may
 * prevent the product from starting its maintenance task or in the worst case may make the maintenance tasks
 * (such as backup or database migration) complete unreliable.
 */
@AsynchronousPreferred
@EventName("stash.maintenance.started")
public class MaintenanceStartedEvent extends MaintenanceEvent {

    public MaintenanceStartedEvent(@Nonnull Object source) {
        super(source);
    }
}
