package com.atlassian.bitbucket.event.attachment;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.attachment.Attachment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when an attachment is deleted.
 *
 * @since 7.0
 */
@AsynchronousPreferred
@EventName("stash.attachment.deleted")
public class AttachmentDeletedEvent extends AttachmentEvent {

    /**
     * Construct a new {@code AttachmentEvent}.
     *
     * @param source       the component raising the event
     * @param repository   the repository
     * @param attachment   the attachment
     */
    public AttachmentDeletedEvent(@Nonnull Object source, @Nonnull Repository repository,
                                  @Nonnull Attachment attachment) {
        super(source, repository, attachment);
    }
}
