package com.atlassian.bitbucket.event.annotation;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.event.api.EventPublisher;

import java.lang.annotation.*;

/**
 * Legacy annotation for events that should be audited by the system.
 * <p>
 * Annotated actions are audited by being added to the audit log, database and potentially other channels.
 * <p>
 * This annotation only affects types used as arguments in {@link EventPublisher#publish}. An example usage would be
 * creating a domain event which extends {@link ApplicationEvent} for a specific action and annotating the event with
 * {@link Audited} to audit the action.
 * <p>
 * {@link Audited} was replaced by {@link Auditable} in 7.0. Internally, an {@link AuditEntry} produced by
 * an implementation of {@link AuditEntryConverter} supplied by this annotation is then subsequently converted to an
 * {@link AuditEvent} (possibly with some information loss or default values being used due to slight differences
 * between the audit representations) before being processed for auditing. Consumers are recommended to use
 * {@link Auditable} with an {@link AuditEventConverter} to convert to an {@link AuditEvent} directly, instead of
 * using {@link Audited}.
 *
 * @see AuditEntry
 * @see AuditEntryConverter
 * @deprecated in 7.0 for removal in 8.0. {@link Auditable} should be used instead.
 */
@Deprecated
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface Audited {

    /**
     * @return a converter to extract the details of the event to be audited
     */
    Class<? extends AuditEntryConverter> converter();

    /**
     * @return additional channels the audit details should be sent to in addition to the audit log.
     */
    String[] channels() default {};

    /**
     * @return the priority of the event
     */
    Priority priority();
}
