package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.util.BuilderSupport;

import javax.annotation.Nonnull;

public class FileContext {

    private final String commitId;
    private final int maxLineLength;
    private final int start;

    private FileContext(Builder builder) {
        this.commitId = builder.commitId;
        this.maxLineLength = builder.maxLineLength;
        this.start = builder.start;
    }

    /**
     * @return the ID of the commit at which file content is being streamed
     */
    @Nonnull
    public String getCommitId() {
        return commitId;
    }

    public int getMaxLineLength() {
        return maxLineLength;
    }

    public int getStart() {
        return start;
    }

    public static class Builder extends BuilderSupport {

        private final String commitId;

        private int maxLineLength;
        private int start;

        public Builder(@Nonnull String commitId) {
            this.commitId = checkNotBlank(commitId, "commitId");
        }

        @Nonnull
        public FileContext build() {
            return new FileContext(this);
        }

        @Nonnull
        public Builder maxLineLength(int value) {
            maxLineLength = value;

            return this;
        }

        @Nonnull
        public Builder start(int value) {
            start = value;

            return this;
        }
    }
}
