package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.commit.Commit;

/**
 * Defines the standard {@link Change change} types which may occur in a given {@link Commit
 * commit}.
 */
public enum ChangeType {

    /**
     * A new file was added.
     */
    ADD,
    /**
     * An existing file was copied to create a new file.
     */
    COPY,
    /**
     * An existing file was deleted.
     */
    DELETE,
    /**
     * An existing file was modified.
     */
    MODIFY,
    /**
     * An existing file was moved to a new path.
     * <p>
     * Note: Renaming a file moves it from an old name to a new one, which also changes its path. As such, a move may
     * affect a file's name, directory or both.
     */
    MOVE,
    /**
     * An SCM-specific change has occurred for which there is no known generic alias.
     */
    UNKNOWN
}
