package com.atlassian.bitbucket.build;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetEvent;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when the build status for a commit is set.
 *
 * @deprecated in 7.6 for removal in 8.0. Please use {@link RepositoryBuildStatusSetEvent} instead
 */
@AsynchronousPreferred
@TransactionAware
@Deprecated
public class BuildStatusSetEvent extends ApplicationEvent {

    private final BuildStatus buildStatus;
    private final String commitId;

    public BuildStatusSetEvent(@Nonnull Object source, @Nonnull String commitId, @Nonnull BuildStatus buildStatus) {
        super(source);

        this.buildStatus = requireNonNull(buildStatus, "buildStatus");
        this.commitId = requireNonNull(commitId, "commitId");
    }

    /**
     * @return the {@link BuildStatus build status} that was set for the commit
     */
    @Nonnull
    public BuildStatus getBuildStatus() {
        return buildStatus;
    }

    /**
     * @return the commit ID for which the {@link BuildStatus build status} was set
     */
    @Nonnull
    public String getCommitId() {
        return commitId;
    }
}
