package com.atlassian.bitbucket.avatar;

import javax.annotation.Nonnull;
import java.io.InputStream;

import static java.util.Objects.requireNonNull;

/**
 * A simple implementation of {@link AvatarSupplier} which accepts the {@code InputStream} containing the avatar's
 * image data as a constructor parameter.
 */
public class SimpleAvatarSupplier extends AbstractAvatarSupplier {

    private final InputStream inputStream;

    /**
     * Constructs a new {@code SimpleAvatarSupplier} which will {@link #open() return} the provided
     * {@code InputStream}.
     *
     * @param inputStream the input stream for this supplier
     * @throws NullPointerException if the provided {@code inputStream} is {@code null}
     */
    public SimpleAvatarSupplier(@Nonnull InputStream inputStream) {
        this(null, inputStream);
    }

    /**
     * Constructs a new {@code SimpleAvatarStream} with the specified {@code contentType} which will
     * {@link #open() return} the provided {@code InputStream}.
     *
     * @param contentType the declared content type for the avatar, which may be {@code null} if not known
     * @param inputStream the input stream for this supplier
     * @throws NullPointerException if the provided {@code inputStream} is {@code null}
     */
    public SimpleAvatarSupplier(String contentType, @Nonnull InputStream inputStream) {
        super(contentType);

        this.inputStream = requireNonNull(inputStream, "inputStream");
    }

    /**
     * Retrieves the {@code InputStream} provided when this supplier was constructed.
     *
     * @return the input stream containing the avatar data
     */
    @Nonnull
    @Override
    public InputStream open() {
        return inputStream;
    }
}
